/* -*- c++ -*-
 * SOCLIB_LGPL_HEADER_BEGIN
 * 
 * This file is part of SoCLib, GNU LGPLv2.1.
 * 
 * SoCLib is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; version 2.1 of the License.
 * 
 * SoCLib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with SoCLib; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 * 
 * SOCLIB_LGPL_HEADER_END
 *
 * Copyright (c) UPMC, Lip6, Asim
 *         Nicolas Pouillon <nipo@ssji.net>, 2007
 *
 * Maintainers: nipo
 */

#include <stdint.h>
#include <iostream>
#include "linked_access_buffer_mcc.h"

namespace soclib { namespace common {

#define tmpl(...) template<typename addr_t, typename id_t> __VA_ARGS__ LinkedAccessBuffer_mcc<addr_t, id_t>

tmpl()::LinkedAccessBuffer_mcc( size_t n_entry = 0, unsigned int page_shift = 0 )
       : m_access(n_entry ? (new entry_t[n_entry]) : NULL), m_n_entry(n_entry), m_page_shift(page_shift)
{
}

tmpl()::~LinkedAccessBuffer_mcc()
{
    if ( m_access )
        delete [] m_access;
}

}}

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

