
/////////////////////////////////////////////////////////////////
//	ADDRESS SPACE SEGMENTATION
//
//	This file must be included in the system.cpp file, 
//	for harware configuration : It is used to build
//	the SOCLIB_SEGMENT_TABLE.
//
//	This file can also be used by the ldscript generator,
//	for embedded software generation.
//	
//	It gives the system integrator the garanty
//	that hardware and software have the same
//	description of the address space segmentation.
/////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
//	.text, .data and other principal segments
/////////////////////////////////////////////////////////////////
#define SEGMENT_PROM_ADDR	0x00000000	// PROM
#define SEGMENT_PROM_SIZE	0x00010000

#define SEGMENT_TEXT_ADDR	0x40000000      // SRAM
#define SEGMENT_TEXT_SIZE	0x00100000

/////////////////////////////////////////////////////////////////
//	global data segment (initialised)
/////////////////////////////////////////////////////////////////
#define SEGMENT_MC_M_BASE       0x40100000
#define SEGMENT_MC_M_SIZE	0x10000000

//////////////////////////////////////////////////////////
//	System devices
///////////////////////////////////////////////////////////

// Hardware components
#define SEGMENT_TTY_ADDR	0x80200000	// Terminal TTY
#define SEGMENT_TTY_SIZE	0x00000010
#define TTY_BASE                0x80200000	// Terminal TTY
#define TTY_SIZE                0x00000010

#define C_PROC0_BASE	        0x01200000
#define C_PROC0_SIZE	        0x00000010

#define C_PROC1_BASE	        0x02200000
#define C_PROC1_SIZE	        0x00000010

#define C_PROC2_BASE	        0x03200000
#define C_PROC2_SIZE	        0x00000010

#define C_PROC3_BASE	        0x04200000
#define C_PROC3_SIZE	        0x00000010

#define SEGMENT_MC_R_BASE       0x20200000
#define SEGMENT_MC_R_SIZE       0x00000008

