/*
 * SOCLIB_LGPL_HEADER_BEGIN
 * 
 * This file is part of SoCLib, GNU LGPLv2.1.
 * 
 * SoCLib is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; version 2.1 of the License.
 * 
 * SoCLib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with SoCLib; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 * 
 * SOCLIB_LGPL_HEADER_END
 *
 * Copyright (c) UPMC, Lip6, SoC
 *         Nicolas Pouillon <nipo@ssji.net>, 2006-2007
 *
 * Maintainers: nipo
 */

#include <iostream>
#include <cstdlib>
#include <getopt.h>

////////////////////////////////////////////////////////////////////
// Part 1 : Include files                                         //
////////////////////////////////////////////////////////////////////

#include "mapping_table.h"

#include "ppc405.h"
#include "vci_xcache_wrapper.h"
#include "vci_ram.h"
#include "vci_multi_tty.h"
#include "vci_fd_access.h"
#include "vci_vgmn.h"


#include "segmentation.h"

// Define our VCI parameters
typedef soclib::caba::VciParams<4,9,32,1,1,1,8,1,1,1> vci_param;

int _main(int argc, char *argv[])
{
	using namespace sc_core;
	// Avoid repeating these everywhere
	using soclib::common::IntTab;
	using soclib::common::Segment;

	////////////////////////////////////////////////////////////////////
	// Part 2 : Mapping table                                         //
	////////////////////////////////////////////////////////////////////

	// Mapping table

	soclib::common::MappingTable maptab(32, IntTab(8), IntTab(8), 0x00300000);

	maptab.add(Segment("ppc_boot", PPC_BOOT_BASE, PPC_BOOT_SIZE, IntTab(0), false));
	maptab.add(Segment("ppc_special", PPC_SPECIAL_BASE, PPC_SPECIAL_SIZE, IntTab(0), true));
	maptab.add(Segment("text" , TEXT_BASE , TEXT_SIZE , IntTab(0), true));
	maptab.add(Segment("data" , DATA_BASE , DATA_SIZE , IntTab(0), true));

	maptab.add(Segment("tty"  , TTY_BASE  , TTY_SIZE  , IntTab(1), false));
	maptab.add(Segment("fd", FD_BASE, FD_SIZE, IntTab(2), false));
																	 /*vcitarget*/
	////////////////////////////////////////////////////////////////////
	// Part 3 : signals                                               //
	////////////////////////////////////////////////////////////////////

	sc_clock	signal_clk("signal_clk");
	sc_signal<bool> signal_resetn("signal_resetn");
   
	sc_signal<bool> signal_ppc4050_it0("signal_ppc4050_it0");
	sc_signal<bool> signal_ppc4050_it1("signal_ppc4050_it1");

	soclib::caba::VciSignals<vci_param> signal_vci_vcish("signal_vci_vcish");
	sc_signal<bool> signal_tty_irq0("signal_tty_irq0"); 
	sc_signal<bool> signal_fd_irq1("signal_fd_irq1"); 

	soclib::caba::VciSignals<vci_param> signal_vci_m0("signal_vci_m0");

	soclib::caba::VciSignals<vci_param> signal_vci_vcimultiram0("signal_vci_vcimultiram0");
	soclib::caba::VciSignals<vci_param> signal_vci_tty("signal_vci_tty");
	soclib::caba::VciSignals<vci_param> signal_vci_vcifd("signal_vci_vcifd");
	soclib::caba::VciSignals<vci_param> signal_vci_vcifd_i("signal_vci_vcifd_i");


	////////////////////////////////////////////////////////////////////
	// Part 4 : instances                                             //
	////////////////////////////////////////////////////////////////////

	soclib::caba::VciXcacheWrapper<vci_param, soclib::common::Ppc405Iss >
		cache0("cache0", 0, maptab,IntTab(0), 
		4 , 1, 8, 
		4 , 1, 8); 

	soclib::common::Loader loader("soft/bin.soft");
	soclib::caba::VciRam<vci_param> vcimultiram0("vcimultiram0", IntTab(0), maptab, loader);
															/*target_index*/
	soclib::caba::VciMultiTty<vci_param> vcitty("vcitty",	IntTab(1), maptab, "vcitty0", NULL);
	/*initiator, target*/
	soclib::caba::VciFdAccess<vci_param> vcifd("vcitfd", maptab, IntTab(1), IntTab(2));
	
	/*initiators , targets , delay, fifo_len*/
	soclib::caba::VciVgmn<vci_param> vgmn("vgmn",maptab, 2, 4, 1, 8);

	////////////////////////////////////////////////////////////////////
	// Part 5 : netlist                                               //
	////////////////////////////////////////////////////////////////////

	cache0.p_clk(signal_clk);
	cache0.p_resetn(signal_resetn);
	cache0.p_irq[0](signal_ppc4050_it0);
	cache0.p_irq[1](signal_ppc4050_it1);
	cache0.p_vci(signal_vci_m0);
  
	vcimultiram0.p_clk(signal_clk);
	vcimultiram0.p_resetn(signal_resetn);
	vcimultiram0.p_vci(signal_vci_vcimultiram0);

	vcitty.p_clk(signal_clk);
	vcitty.p_resetn(signal_resetn);
	vcitty.p_irq[0](signal_tty_irq0); 
	vcitty.p_vci(signal_vci_tty);

	vcifd.p_clk(signal_clk);
	vcifd.p_resetn(signal_resetn);
	vcifd.p_vci_target(signal_vci_vcifd);
	vcifd.p_vci_initiator(signal_vci_vcifd_i);
	vcifd.p_irq(signal_ppc4050_it0);

	vgmn.p_clk(signal_clk);
	vgmn.p_resetn(signal_resetn);
	vgmn.p_to_initiator[0](signal_vci_m0);
	vgmn.p_to_initiator[1](signal_vci_vcifd_i);
	vgmn.p_to_target[0](signal_vci_vcimultiram0);
	vgmn.p_to_target[1](signal_vci_tty);
	vgmn.p_to_target[2](signal_vci_vcifd);
	vgmn.p_to_target[3](signal_vci_vcish);



	sc_start(sc_core::sc_time(0, SC_NS));
	signal_resetn = false;
	sc_start(sc_core::sc_time(1, SC_NS));
	signal_resetn = true;

	////////////////////////////////////////////////////////////////////
	// Part 6 : simulate                                              //
	////////////////////////////////////////////////////////////////////

	sc_start();
	return EXIT_SUCCESS;
}

int sc_main (int argc, char *argv[])
{
	try {
		return _main(argc, argv);
	} catch (std::exception &e) {
		std::cout << e.what() << std::endl;
	} catch (...) {
		std::cout << "Unknown exception occured" << std::endl;
		throw;
	}
	return 1;
}
